<?php

namespace App\Console;
use Illuminate\Console\Scheduling\Schedule;

use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use App\Models\Settings;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        \App\Console\Commands\RunAutoTrading::class,
        \App\Console\Commands\ProcessExpiredTrades::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {

        $schedule->command('auto:run-trading')->everyMinute(); // can be everyMinute, hourly, daily etc.
        // $schedule->command('auto:run-trading')->everyFifteenMinutes();  // Set your frequency here
        $schedule->command('process:trades')->everyMinute();
        $schedule->job(new \App\Jobs\CalculateCopyTradeProfit)->everyMinute();
        // $schedule->command('auto:run-trading')->everyMinute(); // can be everyMinute, hourly, daily etc.


    }




    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');


        require base_path('routes/console.php');
    }



}
