namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Trader extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'bio'];

    public function trades()
    {
        return $this->hasMany(Trade::class);
    }

    public function users()
    {
        return $this->belongsToMany(User::class, 'user_traders');
    }
}
