<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddAutoTradingToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->boolean('auto_trading_enabled')->default(false);
           $table->string('auto_trading_frequency')->default('daily'); // hourly, daily, weekly, monthly
           $table->decimal('auto_trading_percent', 5, 2)->default(15.00); // e.g. 1% daily
            $table->timestamp('last_auto_trade_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            //
        });
    }
}
