'use strict';

var _httpClient = require('./httpClient');

var _metaApi = require('./metaApi.client');

var _metaApi2 = _interopRequireDefault(_metaApi);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const provisioningApiUrl = 'https://mt-provisioning-api-v1.agiliumtrade.agiliumtrade.ai';

/**
 * @test {MetaApiClient}
 */
describe('MetaApiClient', () => {

  let apiClient;
  let httpClient = new _httpClient.HttpClientMock(() => 'empty');

  beforeEach(() => {
    apiClient = new _metaApi2.default(httpClient, 'token');
  });

  it('should return account token type', () => {
    apiClient._tokenType.should.equal('account');
  });

  it('should return api token type', () => {
    apiClient = new _metaApi2.default(httpClient, 'header.payload.sign');
    apiClient._tokenType.should.equal('api');
  });

  it('should check that current token is not JWT', () => {
    apiClient._isNotJwtToken().should.equal(true);
  });

  it('should check that current token is not account token', () => {
    apiClient = new _metaApi2.default(httpClient, 'header.payload.sign');
    apiClient._isNotAccountToken().should.equal(true);
  });

  it('should handle no access error with account token', async () => {
    try {
      await apiClient._handleNoAccessError('methodName');
    } catch (error) {
      error.message.should.equal('You can not invoke methodName method, because you have connected with account access token. ' + 'Please use API access token from https://app.metaapi.cloud/token page to invoke this method.');
    }
  });

  it('should handle no access error with api token', async () => {
    apiClient = new _metaApi2.default(httpClient, 'header.payload.sign');
    try {
      await apiClient._handleNoAccessError('methodName');
    } catch (error) {
      error.message.should.equal('You can not invoke methodName method, because you have connected with API access token. ' + 'Please use account access token to invoke this method.');
    }
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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