'use strict';

var _promise = require('babel-runtime/core-js/promise');

var _promise2 = _interopRequireDefault(_promise);

var _index = require('../index');

var _index2 = _interopRequireDefault(_index);

var _fsExtra = require('fs-extra');

var _fsExtra2 = _interopRequireDefault(_fsExtra);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

require('dotenv').config();
const token = process.env.TOKEN;
let login = process.env.LOGIN;
let password = process.env.PASSWORD;
let serverName = process.env.SERVER;
let serverDatFile = process.env.PATH_TO_SERVERS_DAT;
const api = new _index2.default(token, { application: 'MetaApi', domain: 'project-stock.v3.agiliumlabs.cloud' });

describe('MT5 double synchronization test', () => {

  before(async () => {
    await _fsExtra2.default.ensureDir('./.metaapi');
  });

  afterEach(async () => {
    await _fsExtra2.default.emptyDir('./.metaapi');
  });

  it('should not corrupt files after simultaneous synchronization', async function () {
    if (token) {
      const profiles = await api.provisioningProfileApi.getProvisioningProfiles();
      this.timeout(600000);
      let profile = profiles.find(p => p.name === serverName);
      if (!profile) {
        profile = await api.provisioningProfileApi.createProvisioningProfile({
          name: serverName,
          version: 5
        });
        await profile.uploadFile('servers.dat', serverDatFile);
      }
      if (profile && profile.status === 'new') {
        await profile.uploadFile('servers.dat', serverDatFile);
      }
      let accounts = await api.metatraderAccountApi.getAccounts();
      let account = accounts.find(a => a.login === login && a.type.startsWith('cloud'));
      if (!account) {
        account = await api.metatraderAccountApi.createAccount({
          name: 'Test account',
          type: 'cloud',
          login: login,
          password: password,
          server: serverName,
          provisioningProfileId: profile.id,
          application: 'MetaApi',
          magic: 1000
        });
      }
      let accountCopy = await api.metatraderAccountApi.getAccount(account.id);
      await _promise2.default.all([account.deploy(), accountCopy.deploy()]);
      await _promise2.default.all([account.waitConnected(), accountCopy.waitConnected()]);
      let connection = account.getStreamingConnection();
      let connectionCopy = accountCopy.getStreamingConnection();
      await connection.connect();
      await connectionCopy.connect();
      await _promise2.default.all([connection.waitSynchronized({ timeoutInSeconds: 600 }), connectionCopy.waitSynchronized({ timeoutInSeconds: 600 })]);
      await account.undeploy();
      await accountCopy.undeploy();
      api._metaApiWebsocketClient.removeAllListeners();
      JSON.parse((await _fsExtra2.default.readFile(`./.metaapi/${account.id}-MetaApi-deals.bin`)));
      JSON.parse((await _fsExtra2.default.readFile(`./.metaapi/${account.id}-MetaApi-historyOrders.bin`)));
    }
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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