'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _metatraderDemoAccount = require('./metatraderDemoAccount');

var _metatraderDemoAccount2 = _interopRequireDefault(_metatraderDemoAccount);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Exposes MetaTrader demo account API logic to the consumers
 */
class MetatraderDemoAccountApi {

  /**
   * Constructs a MetaTrader demo account API instance
   * @param {MetatraderDemoAccountClient} metatraderDemoAccountClient MetaTrader demo account REST API client
   */
  constructor(metatraderDemoAccountClient) {
    this._metatraderDemoAccountClient = metatraderDemoAccountClient;
  }

  /**
   * Creates new MetaTrader 4 demo account
   * @param {String} profileId id of the provisioning profile that will be used as the basis for creating this account
   * @param {NewMT4DemoAccount} account demo account to create
   * @return {Promise<MetatraderDemoAccount>} promise resolving with MetaTrader demo account entity
   */
  async createMT4DemoAccount(profileId, account) {
    let demoAccount = await this._metatraderDemoAccountClient.createMT4DemoAccount(profileId, account);
    return new _metatraderDemoAccount2.default(demoAccount);
  }

  /**
   * Creates new MetaTrader 5 demo account
   * @param {String} profileId id of the provisioning profile that will be used as the basis for creating this account
   * @param {NewMT5DemoAccount} account demo account to create
   * @return {Promise<MetatraderDemoAccount>} promise resolving with MetaTrader demo account entity
   */
  async createMT5DemoAccount(profileId, account) {
    let demoAccount = await this._metatraderDemoAccountClient.createMT5DemoAccount(profileId, account);
    return new _metatraderDemoAccount2.default(demoAccount);
  }

}
exports.default = MetatraderDemoAccountApi;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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