'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _assign = require('babel-runtime/core-js/object/assign');

var _assign2 = _interopRequireDefault(_assign);

var _provisioningProfile = require('./provisioningProfile');

var _provisioningProfile2 = _interopRequireDefault(_provisioningProfile);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Exposes provisioning profile API logic to the consumers
 */
class ProvisioningProfileApi {

  /**
   * Constructs a provisioning profile API instance
   * @param {ProvisioningProfileClient} provisioningProfileClient provisioning profile REST API client
   */
  constructor(provisioningProfileClient) {
    this._provisioningProfileClient = provisioningProfileClient;
  }

  /**
   * Retrieves provisioning profiles
   * @param {Number} version optional version filter (allowed values are 4 and 5)
   * @param {String} status optional status filter (allowed values are new and active)
   * @return {Promise<Array<ProvisioningProfile>>} promise resolving with an array of provisioning profile entities
   */
  async getProvisioningProfiles(version, status) {
    let profiles = await this._provisioningProfileClient.getProvisioningProfiles(version, status);
    return profiles.map(p => new _provisioningProfile2.default(p, this._provisioningProfileClient));
  }

  /**
   * Retrieves a provisioning profile by id
   * @param {String} provisioningProfileId provisioning profile id
   * @return {Promise<ProvisioningProfile>} promise resolving with provisioning profile entity
   */
  async getProvisioningProfile(provisioningProfileId) {
    let profile = await this._provisioningProfileClient.getProvisioningProfile(provisioningProfileId);
    return new _provisioningProfile2.default(profile, this._provisioningProfileClient);
  }

  /**
   * Creates a provisioning profile
   * @param {NewProvisioningProfileDto} profile provisioning profile data
   * @return {Promise<ProvisioningProfile>} promise resolving with provisioning profile entity
   */
  async createProvisioningProfile(profile) {
    let id = await this._provisioningProfileClient.createProvisioningProfile(profile);
    return new _provisioningProfile2.default((0, _assign2.default)({}, profile, { _id: id.id, status: 'new' }), this._provisioningProfileClient);
  }

}
exports.default = ProvisioningProfileApi;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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