@extends('layouts.base')

@section('title', 'Services')



@section('content')

<main>
    <!-- section content begin -->
    <section class="py-5">
      <div class="container">
        <div class="row justify-content-center">
          <div class="col-md-12 col-lg-9">
            <h2>
              Join us and shape the future of
              <span class="text-highlight"
                >future of financial services!</span
              >
            </h2>
            <p class="lead text-muted">
              At {{$settings->site_name}} Management, we are dedicated to fostering a
              dynamic and innovative work environment.
            </p>
            <p>
              As a leading financial broker and digital asset management firm,
              we are always looking for talented individuals to join our team
              and contribute to our mission of providing top-tier financial
              services.
            </p>
            <div
              class="row row-cols-1 row-cols-md-1 row-cols-lg-3 gx-0 gx-md-3 gx-lg-5 mt-4"
            >
              <div class="col border-end-md-0 border-end-lg">
                <h4 class="fw-bold">Our oppurtinity</h4>
                <p>
                  We offer continuous learning opportunities, training
                  programs, and career development to help you reach your full
                  potential.
                </p>
                <!-- <a class="btn btn-link link-primary text-decoration-none p-0" href="#">Watch the video<i class="fas fa-angle-right fa-xs ms-1"></i></a> -->
                <!-- <hr class="d-lg-none my-3 my-md-3"> -->
              </div>
              <div class="col border-end-md-0 border-end-lg">
                <h4 class="fw-bold">Our team</h4>
                <p>
                  Work in a collaborative and inclusive environment where your
                  ideas and contributions are valued.
                </p>
                <!-- <a class="btn btn-link link-primary text-decoration-none p-0" href="#">Meet the team<i class="fas fa-angle-right fa-xs ms-1"></i></a> -->
                <!-- <hr class="d-lg-none my-3 my-md-3"> -->
              </div>
              <div class="col">
                <h4 class="fw-bold">Our culture</h4>
                <p>
                  Join a company that operates in various jurisdictions,
                  giving you the chance to work on impactful projects
                  worldwide.
                </p>
                <!-- <a class="btn btn-link link-primary text-decoration-none p-0" href="#">See our values<i class="fas fa-angle-right fa-xs ms-1"></i></a> -->
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- section content end -->
    <!-- section content begin -->
    <section class="py-4">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <h2 class="fw-bold text-center">Open positions</h2>
          </div>
          <div class="col-12 mt-0 mt-md-1 mt-lg-3">
            <div class="border-bottom py-3">
              <div class="row align-content-center gy-1 gy-md-1 gy-lg-0">
                <div class="col-md-12 col-lg-5 d-flex align-items-center">
                  <h5 class="fw-bold mb-0">Compliance Officer</h5>
                </div>
                <div class="col-md-12 col-lg-4 d-flex align-items-center">
                  <div class="d-flex align-items-center">
                    <i
                      class="fas fa-map-marker-alt fa-2x text-danger me-1"
                    ></i>
                    <p class="mb-0">Remote</p>
                  </div>
                </div>
                <div class="col-md-12 col-lg-3 d-flex justify-content-lg-end">
                  <a class="btn btn-info" href="mailto:support@gisstradecapital.com"
                    >Apply for this job
                    <i class="fas fa-file-alt fa-xs ms-1"></i
                  ></a>
                </div>
              </div>
            </div>
            <div class="border-bottom py-3">
              <div class="row align-content-center gy-1 gy-md-1 gy-lg-0">
                <div class="col-md-12 col-lg-5 d-flex align-items-center">
                  <h5 class="fw-bold mb-0">
                    Sales Development Representative
                  </h5>
                </div>
                <div class="col-md-12 col-lg-4 d-flex align-items-center">
                  <div class="d-flex align-items-center">
                    <i
                      class="fas fa-map-marker-alt fa-2x text-danger me-1"
                    ></i>
                    <p class="mb-0">London, United Kingdom</p>
                  </div>
                </div>
                <div class="col-md-12 col-lg-3 d-flex justify-content-lg-end">
                  <a class="btn btn-info" href="mailto:support@gisstradecapital.com"
                    >Apply for this job
                    <i class="fas fa-file-alt fa-xs ms-1"></i
                  ></a>
                </div>
              </div>
            </div>
            <div class="py-3">
              <div class="row align-content-center gy-1 gy-md-1 gy-lg-0">
                <div class="col-md-12 col-lg-5 d-flex align-items-center">
                  <h5 class="fw-bold mb-0">Software Engineer - Backend</h5>
                </div>
                <div class="col-md-12 col-lg-4 d-flex align-items-center">
                  <div class="d-flex align-items-center">
                    <i
                      class="fas fa-map-marker-alt fa-2x text-danger me-1"
                    ></i>
                    <p class="mb-0">Stockholm, Sweden</p>
                  </div>
                </div>
                <div class="col-md-12 col-lg-3 d-flex justify-content-lg-end">
                  <a class="btn btn-info" href="mailto:support@gisstradecapital.com"
                    >Apply for this job
                    <i class="fas fa-file-alt fa-xs ms-1"></i
                  ></a>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- section content end -->
    <!-- section content begin -->
    <section class="py-5 in-cirro-18 bg-white">
      <div class="container mb-4">
        <div class="row d-flex justify-content-center">
          <div class="col-12 col-lg-9">
            <div class="text-center">
              <h1 class="mb-1">Cirro trading academy</h1>
              <p class="lead">Explore, Learn, and Grow</p>
            </div>
            <div class="row row-cols-1 row-cols-md-3 gx-2 gy-1 gy-md-0 mt-3">
              <div class="col">
                <a class="btn btn-outline-primary w-100"
                  ><i class="fas fa-video fa-lg me-1"></i>9 Lessons 70+
                  Videos</a
                >
              </div>
              <div class="col">
                <a class="btn btn-outline-primary w-100"
                  ><i class="fas fa-graduation-cap fa-lg me-1"></i>Test your
                  Knowledge</a
                >
              </div>
              <div class="col">
                <a class="btn btn-outline-primary w-100"
                  ><i class="fas fa-award fa-lg me-1"></i>Certificate
                  Awarded</a
                >
              </div>
            </div>
          </div>
          <div class="col-12 mt-5">
            <div
              class="row d-flex align-items-center gx-0 gx-lg-5 gy-3 gy-lg-0"
            >
              <div class="col-12 col-lg-8 bigger-picture">
                <div class="video-training position-relative me-0 me-xl-5">
                  <img
                    class="w-100"
                   src="temp/frontpage/img/in-cirro-18-video.jpg"
                    alt="sample-images"
                    width="626"
                    height="368"
                  />
                  <div
                    class="position-absolute top-50 start-50 translate-middle"
                  >
                    <a
                      href="https://www.youtube.com/watch?v=F3QpgXBtDeo"
                      data-width="900"
                      data-height="506"
                      data-iframe="https://www.youtube.com/embed/F3QpgXBtDeo?autoplay=1&amp;playsinline=1"
                    >
                      <div class="play-video-button"></div>
                      <i class="fas fa-play"></i>
                    </a>
                  </div>
                </div>
              </div>
              <div class="col-12 col-lg-4">
                <h3 class="mt-1">What you will learn</h3>
                <ul class="fa-ul lh-lg">
                  <li>
                    <span class="fa-li"
                      ><i class="fas fa-check-square text-info"></i></span
                    >Introduction to Financial Trading
                  </li>
                  <li>
                    <span class="fa-li"
                      ><i class="fas fa-check-square text-info"></i></span
                    >Technical Analysis
                  </li>
                  <li>
                    <span class="fa-li"
                      ><i class="fas fa-check-square text-info"></i></span
                    >Fundamental Analysis
                  </li>
                  <li>
                    <span class="fa-li"
                      ><i class="fas fa-check-square text-info"></i></span
                    >When to Enter & Exit Trades
                  </li>
                  <li>
                    <span class="fa-li"
                      ><i class="fas fa-check-square text-info"></i></span
                    >How to Manage Risk
                  </li>
                  <li>
                    <span class="fa-li"
                      ><i class="fas fa-check-square text-info"></i></span
                    >Trading Psychology
                  </li>
                </ul>
                <a href="webtrade.htm" class="btn btn-link mt-2"
                  ><i class="fas fa-arrow-right"></i>Web Trader</a
                >
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- section content end -->
    <!-- section content begin -->
    <section
      class="py-5 bg-primary text-white in-cirro-19"
      style="background: url(img/in-cirro-19-background.png) no-repeat bottom"
    >
      <div class="container my-2">
        <div class="row d-flex justify-content-center">
          <div class="col-12 col-lg-10">
            <div
              class="row row-cols-1 row-cols-lg-2 align-items-center gy-3 gy-lg-0"
            >
              <div class="col">
                <span class="badge bg-info mb-2">Announcing</span>
                <h2 class="text-white mt-2 mb-1">
                  <span class="display-4">$4.95</span> online stocks,
                  currencies & commodities trades
                </h2>
                <p class="mb-4">
                  A simplified MT4 and MT5 version allowing you to access your
                  trading account from your browser.
                </p>
                <a href="webtrade.htm" class="btn btn-link"
                  ><i class="fas fa-arrow-right"></i>Web Trader</a
                >
              </div>
              <div class="col">
                <div class="card card-body px-4">
                  <h3 class="text-white text-center mt-1">
                    Get Best Signals.
                  </h3>
                  <form class="row g-1 mb-2" method="POST">
                    <div class="col-12">
                      <input
                        class="form-control"
                        id="fullname"
                        name="name"
                        type="text"
                        placeholder="Full Name"
                        aria-label="Full Name"
                        required=""
                      />
                    </div>
                    <div class="col-12">
                      <input
                        class="form-control"
                        id="emailaddress"
                        name="email"
                        type="text"
                        placeholder="Email address"
                        aria-label="Email address"
                        required=""
                      />
                    </div>
                    <div class="col-12">
                      <input
                        class="form-control"
                        id="phonenumber"
                        name="subject"
                        type="text"
                        placeholder="Phone Number"
                        aria-label="Phone Number"
                        required=""
                      />
                    </div>
                    <div class="col-12">
                      <input
                        class="form-control"
                        id="telegram"
                        name="message"
                        type="text"
                        placeholder="Telegram ID"
                        aria-label="Telegram ID"
                        required=""
                      />
                    </div>

        <div class="input-group">
      <div class="input-group-prepend" style="width:50%">
        <img src="temp/frontpage/img/captcha/captcha.png" alt="" srcset="">
      </div>
      <input style="color:black;width:50%" type="text" value="" placeholder="Enter Captcha" name="_captcha" class="form-control font-weight-bold" id="captcha" required>
    </div>
    <span style="color:crimson"></span>
    <br>
                        <div class="d-grid">
                      <button
                        class="btn btn-info"
                        id="sendemail"
                        type="submit"
                        name="contact"
                      >
                        Submit
                      </button>
                    </div>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- section content end -->
  </main>


@endsection

