@extends('layouts.dash1')
@section('title', $title)
@section('content')
    <!-- Page title -->


    <div class="wrapper-content">
    <!-- <div class="container" style="max-width:1300px"> -->
    <div class="container" style="max-width:1400px">


<div > <!-- Keeps space for alerts -->
    <x-danger-alert />
    <x-success-alert />
       <x-error-alert />
</div>


  <title> {{ Auth::user()->name }} | {{$title}} </title>

  <div class="d-flex align-items-center p-3 bg-dark text-white rounded shadow">
    <i class="fas fa-user-circle fa-2x me-3"></i> <!-- User Icon -->
    <p class="mb-0 fs-5"><b>Username:</b> {{ Auth::user()->name }}</p>
</div>



<!-- TradingView Widget BEGIN -->
<!-- TradingView Widget BEGIN -->
<div class="tradingview-widget-container">
  <div class="tradingview-widget-container__widget"></div>
  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-ticker-tape.js" async>
    {
      "symbols": [{
          "proName": "FOREXCOM:SPXUSD",
          "title": "S&P 500"
        },
        {
          "proName": "FOREXCOM:NSXUSD",
          "title": "Nasdaq 100"
        },
        {
          "proName": "FX_IDC:EURUSD",
          "title": "EUR/USD"
        },
        {
          "proName": "BITSTAMP:BTCUSD",
          "title": "BTC/USD"
        },
        {
          "proName": "BITSTAMP:ETHUSD",
          "title": "ETH/USD"
        }
      ],
      "showSymbolLogo": true,
      "colorTheme": "dark",
      "isTransparent": false,
      "displayMode": "relative",
      "locale": "en"
    }
  </script>
</div>
<!-- TradingView Widget END -->
@include('user.menu')

<div class="container ">

    <div class="row gy-4 gx-4">
        @if($experts->count() > 0)
            @foreach($experts as $expert)
                <div class="col-16 col-md-8 col-lg-8">
                    <div class="card  text-white border-0 shadow-lg rounded-4 h-100 p-4" style="min-height: 100%;">
                        <div class="d-flex flex-column align-items-center text-center">
                            <!-- Profile Image -->
                            <div class="mb-3" style="width: 100px; height: 100px;">
                                <img src="{{ asset('storage/app/public/' . $expert->profile_picture) }}"
                                     alt="{{ $expert->name }}"
                                     class="img-fluid rounded-circle w-100 h-100"
                                     style="object-fit: cover; border: 2px solid rgba(255,255,255,0.2);">
                            </div>

                            <!-- Name -->
                            <h5 class="fw-bold text-light mb-1 fs-5">{{ $expert->name }}</h5>
                            <p class="text-secondary fs-6 mb-3">Professional Trader</p>

                            <!-- Stats -->
                            <div class="w-100">
                                <div class="row text-start fs-6 mb-3">
                                    <div class="col-6 mb-2">
                                        <strong class="text-white">Profit Share:</strong>
                                        <div class="text-info">{{ $expert->profit_share_percentage }}%</div>
                                    </div>
                                    <div class="col-6 mb-2">
                                        <strong class="text-white">Win Rate:</strong>
                                        <div class="text-success">{{ $expert->win_rate }}%</div>
                                    </div>
                                    <div class="col-6 mb-2">
                                        <strong class="text-white">Min Capital:</strong>
                                        <div class="text-danger">${{ number_format($expert->min_startup_capital, 2) }}</div>
                                    </div>
                                    <div class="col-6 mb-2">
                                        <strong class="text-white">Total Profit:</strong>
                                        <div class="text-primary">${{ number_format($expert->total_profit, 2) }}</div>
                                    </div>
                                </div>
                            </div>

                            <!-- Action Button -->
                            @php
                                $isCopying = $activeCopies->where('expert_id', $expert->id)->where('status', 'active')->count() > 0;
                            @endphp

                            <div class="d-flex flex-column flex-sm-row gap-2 w-100 mt-auto">
                                @if($isCopying)
                                    <form id="stop-copying-form-{{ $expert->id }}" action="{{ route('stopCopying', $expert->id) }}" method="POST" class="w-100">
                                        @csrf
                                        <button type="button" class="btn btn-outline-danger btn-sm w-100 confirmStopCopying" data-id="{{ $expert->id }}">
                                            <i class="bi bi-x-circle me-1"></i> Stop Copying
                                        </button>
                                    </form>
                                @else
                                    <form id="start-copying-form-{{ $expert->id }}" action="{{ route('startCopying', $expert->id) }}" method="POST" class="w-100">
                                        @csrf
                                        <button type="button" class="btn btn-success btn-sm w-100 confirmStartCopying" data-id="{{ $expert->id }}">
                                            <i class="bi bi-play-circle me-1"></i> Start Copying
                                        </button>
                                    </form>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        @else
            <div class="col-12 text-center">
                <div class="alert alert-info text-white bg-secondary border-0">
                    <i class="bi bi-info-circle me-2"></i> No experts available at the moment.
                </div>
            </div>
        @endif
    </div>


</div>

















</div>
<!-- Include SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    // Confirmation for Start Copying
    document.querySelectorAll('.confirmStartCopying').forEach(button => {
        button.addEventListener('click', function () {
            let expertId = this.getAttribute('data-id');
            let form = document.getElementById(`start-copying-form-${expertId}`);

            Swal.fire({
                title: "Start Copying?",
                text: "Are you sure you want to start copying this expert?",
                icon: "info",
                showCancelButton: true,
                confirmButtonColor: "#28a745",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, Start",
                cancelButtonText: "No, Cancel"
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit(); // Submit the correct form
                }
            });
        });
    });

    // Confirmation for Stop Copying
    document.querySelectorAll('.confirmStopCopying').forEach(button => {
        button.addEventListener('click', function () {
            let expertId = this.getAttribute('data-id');
            let form = document.getElementById(`stop-copying-form-${expertId}`);

            Swal.fire({
                title: "Stop Copying?",
                text: "Are you sure you want to stop copying this expert?",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#d33",
                cancelButtonColor: "#3085d6",
                confirmButtonText: "Yes, Stop",
                cancelButtonText: "No, Cancel"
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit(); // Submit the correct form
                }
            });
        });
    });
</script>



</div>
@endsection
