@extends('layouts.dash1')
@section('title', $title)
@section('content')
    <!-- Page title -->


    <div class="wrapper-content">
    <!-- <div class="container" style="max-width:1300px"> -->
    <div class="container" style="max-width:1400px">
        <x-danger-alert />
        <x-success-alert />
        <x-error-alert />


  <title> {{ Auth::user()->name }} | {{$title}} </title>

<div class="row  align-items-center justify-content-between" style="margin-top:10px">
  <div class="col-16 col-sm-16">
    <p style="color:white"> <b>Username :</b> {{ Auth::user()->name }} </p></div>
</div>


<!-- TradingView Widget BEGIN -->
<!-- TradingView Widget BEGIN -->
<div class="tradingview-widget-container">
  <div class="tradingview-widget-container__widget"></div>
  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-ticker-tape.js" async>
    {
      "symbols": [{
          "proName": "FOREXCOM:SPXUSD",
          "title": "S&P 500"
        },
        {
          "proName": "FOREXCOM:NSXUSD",
          "title": "Nasdaq 100"
        },
        {
          "proName": "FX_IDC:EURUSD",
          "title": "EUR/USD"
        },
        {
          "proName": "BITSTAMP:BTCUSD",
          "title": "BTC/USD"
        },
        {
          "proName": "BITSTAMP:ETHUSD",
          "title": "ETH/USD"
        }
      ],
      "showSymbolLogo": true,
      "colorTheme": "dark",
      "isTransparent": false,
      "displayMode": "relative",
      "locale": "en"
    }
  </script>
</div>
<!-- TradingView Widget END -->
@include('user.menu')
<div class="row">
    <div class="container card">
    <div class="col-md-12">






        <h2>My Loan Applications</h2>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Amount ($)</th>
                    <!--<th>Credit Facility</th>-->
                    <th>Duration (Months)</th>
                    <th>Monthly Net Income ($)</th>
                    <!--<th>Purpose</th>-->
                    <th>Status</th>
                    <th>Date Applied</th>
                </tr>
            </thead>
            <tbody>
                @forelse($loans as $loan)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{$settings->currency}}{{ number_format($loan->amount, 2) }}</td>
                        <!--<td>{{ $loan->credit_facility }}</td>-->
                        <td>{{ $loan->duration }}</td>
                        <td>{{$settings->currency}}{{ $loan->monthly_income }}</td>
                        <!--<td>{{ $loan->purpose }}</td>-->
                        <td>
                            <span class="badge
                                {{ $loan->status == 'approved' ? 'badge-success' : ($loan->status == 'pending' ? 'badge-warning' : 'badge-danger') }}">
                                {{ ucfirst($loan->status) }}
                            </span>
                        </td>
                        <td>{{ $loan->created_at->format('Y-m-d H:i') }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="8" class="text-center">No loan applications found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>









</div>
    </div>
</div>
</div>
</div>
@endsection
