@inject('uc', 'App\Http\Controllers\User\UsersController')
@php
    $array = \App\Models\User::all();
    $usr = Auth::user()->id;
    $totalReferrals = \App\Models\User::where('ref_by', Auth::user()->id)->count();

@endphp
@extends('layouts.dash1')
@section('title', $title)
@section('content')


<div class="wrapper-content">
    <!-- <div class="container" style="max-width:1300px"> -->
    <div class="container" style="max-width:1400px">


  <title> {{ Auth::user()->name }} | {{$title}}</title>

<div class="row  align-items-center justify-content-between" style="margin-top:10px">
  <div class="col-16 col-sm-16">
    <p style="color:white"> <b>Refer User</b> </p></div>
</div>


<!-- TradingView Widget BEGIN -->
<!-- TradingView Widget BEGIN -->
<div class="tradingview-widget-container">
  <div class="tradingview-widget-container__widget"></div>
  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-ticker-tape.js" async>
    {
      "symbols": [{
          "proName": "FOREXCOM:SPXUSD",
          "title": "S&P 500"
        },
        {
          "proName": "FOREXCOM:NSXUSD",
          "title": "Nasdaq 100"
        },
        {
          "proName": "FX_IDC:EURUSD",
          "title": "EUR/USD"
        },
        {
          "proName": "BITSTAMP:BTCUSD",
          "title": "BTC/USD"
        },
        {
          "proName": "BITSTAMP:ETHUSD",
          "title": "ETH/USD"
        }
      ],
      "showSymbolLogo": true,
      "colorTheme": "dark",
      "isTransparent": false,
      "displayMode": "relative",
      "locale": "en"
    }
  </script>
</div>
<!-- TradingView Widget END -->

<style>
    
    .activity-block {
  background-color: #fff;
  border-radius: 15px;
  box-shadow: 0 4px 20px rgba(0,0,0,0.05);
  transition: 0.3s ease-in-out;
}
.activity-block:hover {
  transform: translateY(-5px);
}

</style>
@include('user.menu')


<div class="row">
    <div class="col-md-12">
        <div class="card">

            {{-- Referral Summary Cards --}}
            <div class="card-body">
                <div class="row mb-4">
                    <div class="col-md-4">
                        <div class="activity-block success text-center p-3">
                            <div class="media-body">
                                <h5 class="font-weight-bold text-success">
                                    {{ $settings->currency }}{{ number_format(Auth::user()->ref_bonus, 2, '.', ',') }}
                                </h5>
                                <p>Referral Bonus</p>
                            </div>
                            <i class="fa fa-gift fa-2x text-muted"></i>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="activity-block info text-center p-3">
                            <div class="media-body">
                                <h5 class="font-weight-bold text-primary">
                                    {{ $settings->currency }}{{ number_format(Auth::user()->ref_bonus, 2, '.', ',') }}
                                </h5>
                                <p>Withdrawable Referral Amount</p>
                            </div>
                            <i class="fa fa-wallet fa-2x text-muted"></i>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="activity-block primary text-center p-3">
                            <div class="media-body">
                                <h5 class="font-weight-bold text-info">
                                    {{ $totalReferrals }}
                                </h5>
                                <p>Total Referrals</p>
                            </div>
                            <i class="fa fa-users fa-2x text-muted"></i>
                        </div>
                    </div>
                </div>

                {{-- Referral Info Section --}}
                <div class="p-4 row">
                    <div class="col-md-8 offset-md-2 text-center">
                        <strong>You can refer users by sharing your referral link:</strong><br><br>
                        <div class="mb-3 input-group">
                            <input type="text" class="form-control readonly" value="{{ Auth::user()->ref_link }}" id="reflink" readonly>
                            <div class="input-group-append">
                                <button class="btn btn-outline-secondary" onclick="copyReferralLink()" type="button">
                                    <i class="fas fa-copy"></i>
                                </button>
                            </div>
                        </div>

                        <strong>or your Referral ID</strong><br>
                        <h4 class="text-success">{{ Auth::user()->username }}</h4>

                        <h5 class="title1 text-center">You were referred by</h5>
                        <i class="fa fa-user fa-2x d-block"></i>
                        <small>{{ $uc->getUserParent($usr) }}</small>
                    </div>

                    <div class="mt-4 col-md-12">
                        <h6 class="text-left title1">Your Referrals</h6>
                        <div class="table-responsive">
                            <table class="table UserTable table-hover">
                                <thead>
                                    <tr>
                                        <th>Client name</th>
                                        <th>Ref. level</th>
                                        <th>Parent</th>
                                        <th>Client status</th>
                                        <th>Date registered</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    {!! $uc->getdownlines($array, $usr) !!}
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div> {{-- end inner row --}}
            </div> {{-- end card-body --}}
        </div> {{-- end card --}}
    </div> {{-- end col --}}
</div> {{-- end row --}}


<!-- Include SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    function copyReferralLink() {
        let copyText = document.getElementById("reflink");

        // Select the text
        copyText.select();
        copyText.setSelectionRange(0, 99999); // For mobile devices

        // Copy the text
        document.execCommand("copy");

        // Show SweetAlert2 success message
        Swal.fire({
            title: "Copied!",
            text: "Referral link copied to clipboard.",
            icon: "success",
            confirmButtonColor: "#3085d6",
            confirmButtonText: "OK"
        });
    }
</script>



@endsection
